<?php
$page = 'About Us | Publish With Pros';
$pageDesc = "Read our blog for valuable insights, tips, and trends in book publishing. Stay informed with expert advice and industry updates.";
$pageTag = "";
include 'includes/header.php';
?>

<section class="section s1 home-banner nitro-lazy about-page">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-12 div-text">
                <h1 class="heading">About Us</h1>
                <hr>
            </div>
        </div>
    </div>
</section>

<section class="about-content">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="about-meta">
                    <h2>Where It <span>Started</span></h2>
                    <p>In 1997, at just 17 years old, Aaron Kenn (our founding chairman, affectionately known as
                        THE BIG BIRD) began his career in a small publishing house. Driven by a deep passion for
                        books and their transformative power, Aaron dedicated himself to learning and mastering
                        the world of authorship. Over the years, he worked with various book writing and
                        publishing firms, striving to establish himself as a prominent name in the industry.
                        While working full-time, Aaron earned a degree in Economics from the London School of
                        Economics, and he led significant teams of editors, publishers, and marketers. His
                        expertise not only helped authors brainstorm and craft their works but also played a
                        crucial role in marketing them effectively.</p>
                    <p>The first decade of Aaron’s career was both inspiring and foundational. It supported his
                        decision to leave his job and start his own venture, driven by a vision to have more
                        time and control to serve his clients, whom he considered family. Aaron also assisted
                        many friends and family members in successfully writing and publishing their own books.
                        This growing recognition as an industry leader led to the creation of the first
                        iteration of publishwithpros, which began as a class for aspiring authors
                        dreaming of writing their own books.</p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="about-one-img">
                    <img src="img/about1.webp" alt="img">
                </div>
            </div>
        </div>
    </div>
</section>

<section class="lives">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="about-one-img">
                    <img src="img/about2.webp" alt="img">
                </div>
            </div>
            <div class="col-md-6">
                <div class="lives-meta">
                    <h2>Changing <span>Lives</span></h2>
                    <p>Later that year, Kenn’s life was profoundly affected by a tragic event. His close
                        friend’s young daughter, Lisa, just 9 years old, passed away suddenly during a
                        family vacation. This heartbreaking loss left Kenn grappling with deep grief and a
                        new perspective on the fragility of life. In his struggle to cope, Kenn felt a
                        powerful urge to honor Lisa’s memory by achieving what she would never have the
                        chance to.</p>
                    <p>While sorting through Lisa’s belongings, Kenn discovered a journal filled with her
                        enchanting drawings and whimsical stories. It was clear that Lisa, inspired by
                        Kenn’s own journey as a writer, had started crafting her own magical tales. Although
                        the book was compiled for friends and family and never published, its impact on
                        their small community was profound. The stories and memories of Lisa left a lasting
                        imprint on Kenn, helping him channel his grief into a meaningful endeavor.</p>
                    <p>The powerful effect of Lisa’s stories on readers made Kenn realize the profound
                        potential of a book to preserve a legacy and touch lives. This insight ignited a
                        deep passion within him. Inspired by Lisa’s stories, Kenn, along with his visionary
                        co-founders, established “Publish With Pros” (publishwithpros) - a one-window solution for
                        authors. Publish With Pros provides comprehensive services including writing, editing, printing,
                        marketing, and audiobooks.</p>
                    <p>Kenn’s journey, driven by his desire to honor Lisa and his personal transformation,
                        gave him a renewed sense of purpose. Through Publish With Pros, he now finds fulfillment in
                        guiding others through every step of the publishing process, ensuring that every
                        story—no matter how small—can leave a lasting impact on the world. By turning
                        personal tragedies into a beacon of hope and inspiration, Kenn is committed to
                        helping others create their own legacies, just as Lisa’s stories continue to inspire
                        and uplift those who remember her.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="purpose">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="about-meta">
                    <h2>The Brand <span>Purpose</span></h2>
                    <p>At Publish With Pros, we believe there’s a story within each of us. By publishing your story, you can
                        create significant impact and change many lives with a single book.</p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="about-meta">
                    <h2>The Brand <span>Mission</span></h2>
                    <p>Our mission is to help our authors self-publish 100,000 books by 2037. Through the
                        education and support we provide, we aim to transform 150 million lives by publishing
                        these books.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="container values-heading">
    <div class="row">
        <div class="col-md-12">
            <h2 class=text-center>The Brand <span>Values</span></h2>
        </div>
    </div>
</div>
<section class="values">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="values-meta">
                    <h5><span>1.</span> Honesty & Integrity Always Win</h5>
                    <p>We are committed to trust and transparency with our authors and each other. We strive to
                        help authors share their stories authentically by providing honest, compassionate, and
                        constructive feedback. We are also transparent about our results, highlighting real
                        stories and achievements.</p>
                    <h5><span>2.</span> Fail Fast, Fail Forward, Fail Often</h5>
                    <p>We believe that true failure comes from not making the effort. Setbacks are embraced as
                        part of the journey, offering opportunities to learn and advance. We are dedicated to
                        continuous innovation, learning from our failures, and raising industry standards.</p>
                    <h5><span>3.</span> Hard Work & Continuous Improvement</h5>
                    <p>Writing a book is challenging, but it is one of the most rewarding and potentially
                        profitable endeavors. We push ourselves and our authors to exceed boundaries and achieve
                        more than initially imagined.</p>
                    <h5><span>4.</span> Everyone Is Responsible For Facilitating Change</h5>
                    <p>Change begins with you. Your actions and story have the power to transform lives and
                        businesses. Every team member is empowered to tackle challenges, innovate solutions, and
                        drive progress, and we actively welcome author feedback to improve continuously.</p>
                    <h5><span>5.</span> Best Is The Standard</h5>
                    <p>At Publish With Pros, "best" isn’t just a goal—it’s our standard. We pour our passion into making
                        every book shine with unmatched quality and professionalism before publishing. Your
                        story deserves nothing less than excellence, and we're committed to making sure it makes
                        a powerful impact on the world out there.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="mision">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="mision-meta">
                    <h2>Your Story, <span>Our Mission</span></h2>
                    <p>We believe every story has the power to captivate and inspire. From our modest start to
                        becoming your ultimate publishing ally, we’re passionate about bringing your vision to
                        life with unparalleled brilliance. Our top-tier writing, editing, and marketing services
                        ensure your book doesn’t just make it to print—it makes waves.</p>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="container">
    <section class="cta-about" data-aos="fade-in" data-aos-duration="2000">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="cta-meta">
                        <h2>Ready to turn your story into a <span>legacy?</span> Start your journey with us today and <span>experience the Publish With Pros difference.</span></h2>
                        <div class="text-center mt-5"> <button onclick="javascript:$zopim.livechat.window.show();" class="primary-btn">Chat With Our
                                Creative Strategist</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<section class="section s2" id="request">
    <div class="container">
        <div class="form-area">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-right" data-aos-duration="2000">
                    <div class="div-img">
                        <img alt="Request A Free Proposal" width="436" height="463" src="img/rfp-man.webp" />
                    </div>
                </div>
                <div class="col-md-6" data-aos="fade-left" data-aos-duration="2000">
                    <div class="form-head text-center">
                        <h2>Let’s Get Started and make your <span>story heard around the world!</span></h2>
                    </div>
                    <div class="footer-rfp form-style">
                        <div class="form-body">
                        <?php include "includes/form.php" ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php include "includes/footer.php" ?>