<?php
$page = 'Book Editing Services | Publish With Pros';
$pageDesc = "Publish With Pros provides top-notch book editing services for authors, refining your work to perfection. Rely on our expert team for high-quality edits and revisions.";
$pageTag = "";
include 'includes/header.php';
?>
<section class="section s1 home-banner nitro-lazy">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-7 div-text">
                <h1 class="heading">Expert <span class="heading-ani typeJsText" data-typetext="Editing"></span>
                    Services.</h1>
                <p>Our experts are here to ensure your manuscript is submission-ready. They refine your writing,
                    correct grammar, style, layout, citations, formatting, references, and more.</p>
                <ul class="list-style for-mul">
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Multiple editing levels </span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Niche-specific editing </span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Expert editorial review </span></li>
                </ul>
                <div class="banner-btns"> <a href="#request" class="talk-chat"> Get Started </a> <a
                        href="tel:<?php echo $phone ?>" class="talk-phone phons-mobile call-func"><i class="fa-solid fa-phone"></i> <?php echo $phone ?></a> </div>
            </div>
            <div class="col-md-5 div-img">
                <img alt="img" width="446" height="596" src="img/banner_img.webp" />
            </div>
        </div>
    </div>
</section>
<section class="section s2" id="request">
    <div class="container">
        <div class="form-area">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-right" data-aos-duration="2000">
                    <div class="div-img">
                        <img alt="Request A Free Proposal" width="436" height="463" src="img/rfp-man.webp" />
                    </div>
                </div>
                <div class="col-md-6" data-aos="fade-left" data-aos-duration="2000">
                    <div class="form-head text-center">
                        <h2>Discuss Your Edits With Our <span>Master Editors</span>.</h2>
                    </div>
                    <div class="footer-rfp form-style">
                        <div class="form-body">
                            <?php include "includes/form.php" ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s4 nitro-lazy">
    <div class="container">
        <div class="heading text-center" data-aos="fade-down" data-aos-duration="2000">
            <h2>Versatile Editing Options</h2>
            <p>We offer a range of editing services to cater to your specific needs, ensuring your manuscript is
                polished and ready for publication. These editing solutions are designed to enhance the clarity,
                structure, and overall quality of your work.</p>
        </div>
        <div class="market-book-slider">
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" src="img/editing1.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Copy Editing</h3>
                        <p>We’ll improve the clarity of your sentences while conducting a technical edit that
                            addresses grammar, punctuation, and spelling.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" src="img/editing2.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Line Editing</h3>
                        <p>This involves a high-level review of structure and content, enhancing tone and
                            organization, with a basic check for spelling, grammar, and punctuation.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" src="img/editing3.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Developmental Editing</h3>
                        <p>We’ll assess the plot, structure, and point of view, evaluate characterization and
                            arcs, and examine recurring themes, offering actionable advice to refine the
                            language and focus your message—helpful for adjusting word count.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" src="img/editing4.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Proofreading</h3>
                        <p>We provide a final polish for your manuscript by eliminating spelling mistakes,
                            correcting grammar and punctuation errors, removing typos, and resolving any
                            formatting issues.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s8">
    <div class="container">
        <div class="form-area">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-left" data-aos-duration="2000">
                    <div class="form-head text-center">
                        <h2>Hire the Best Editing <span>Services Online</span>!</h2>
                        <p>Talk to Our Experts</p>
                    </div>
                    <div class="footer-rfp form-style">
                        <div class="form-body">
                            <?php include "includes/form.php" ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="div-img" data-aos="fade-right" data-aos-duration="2000">
                        <img alt="Request A Free Proposal" width="436" height="463" src="img/lowe-form.webp" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s6" data-aos="fade-up" data-aos-duration="2000">
    <div class="container editing-com">
        <div class="heading text-center">
            <h2>Our Successful Editing Process </h2>
        </div>
        <div class="row ttff">
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-1.webp" alt="Number one">
                    <h4 class="mt-2">Review </h4>
                    <p>Discuss the project details, scope of the project, and estimated timeline with the
                        dedicated project manager. </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-2.webp" alt="Number two">
                    <h4 class="mt-2">Editing Process and Feedback</h4>
                    <p>Evaluate your manuscript’s strengths and weaknesses to select the best editing services.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-3.webp" alt="Number three">
                    <h4 class="mt-2">Reviewing Edits</h4>
                    <p>Editing will be done in various sets so that you can keep track of the progress. </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-4.webp" alt="Number four">
                    <h4 class="mt-2">Proofreading for Higher Accuracy</h4>
                    <p>Once the editing is completed, we give a final look to refine your manuscript to
                        perfection.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s7" data-aos="fade-in" data-aos-duration="2000">
    <div class="container">
        <div class="heading text-center width-70 m-auto">
            <h2>Q/A Session.</h2>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="accordion">
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>01</p>
                            </span>
                            <h4>What types of editing services do you offer?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We offer developmental editing, line editing, copy editing, and proofreading to
                                cater to all stages of your manuscript’s journey.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>02</p>
                            </span>
                            <h4>What is your turnaround time for editing a manuscript?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Turnaround times vary depending on the length and complexity of your manuscript,
                                but we typically return edited documents within 1-4 weeks.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>03</p>
                            </span>
                            <h4>What qualifications do your editors have?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Our editors are experienced professionals with degrees in English, creative
                                writing, or related fields and have extensive experience in publishing.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>04</p>
                            </span>
                            <h4>How do you ensure the confidentiality of my manuscript?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We respect your privacy and confidentiality. All manuscripts are handled with the
                                utmost care, and we are happy to sign a non-disclosure agreement (NDA) if
                                requested.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>05</p>
                            </span>
                            <h4>Can I request specific changes or feedback on certain areas of my manuscript?
                            </h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Absolutely! You are welcome to provide us with specific instructions or areas of
                                focus when you submit your manuscript.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>06</p>
                            </span>
                            <h4>Will my voice be preserved during the editing process?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, our editors work diligently to improve readability and clarity while
                                preserving your unique voice and style.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 faq-rowr">
                <div class="accordion">
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>07</p>
                            </span>
                            <h4>Do you offer any revisions after the initial edit?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, our editing packages include one or multiple rounds of revisions (depending
                                on your package) to ensure you are completely satisfied with the final product.
                            </p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>08</p>
                            </span>
                            <h4>How are your editing services priced?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Though we offer affordable rates, pricing is still based on the word count and
                                the level of editing required. Contact us for a detailed quote based on your
                                manuscript’s needs.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>09</p>
                            </span>
                            <h4>Do you offer any discounts for bulk or repeat clients?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we offer discounts for bulk projects and returning clients. Please contact
                                us for more details.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>10</p>
                            </span>
                            <h4>Can you help with formatting my manuscript for publishing?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we offer formatting services to ensure your manuscript meets the
                                requirements of traditional publishers or self-publishing platforms.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>11</p>
                            </span>
                            <h4>Will I be able to track the changes made to my manuscript?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we use Microsoft Word’s Track Changes feature so you can see all edits and
                                suggestions clearly.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>12</p>
                            </span>
                            <h4>What happens if I am not satisfied with the editing services?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Your satisfaction is our priority. If you are not satisfied, we will work with
                                you to address your concerns and make necessary adjustments.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php include "includes/footer.php" ?>

<script>
    let typeJsText = document.querySelector(".typeJsText");
    let textArray = typeJsText.dataset.typetext.split("");
    let counter = -1;
    typeJsText.innerHTML = "";

    function typeJs() {
        if (counter < typeJsText.dataset.typetext.length) {
            counter++;
            typeJsText.innerHTML += typeJsText.dataset.typetext.charAt(counter);
            textArray = typeJsText.dataset.typetext.split("");
        } else {
            textArray.pop();
            typeJsText.innerHTML = textArray.join("");
            if (textArray.length == 0) {
                counter = -1;
            }
        }
    }
    setInterval(() => {
        typeJs();
    }, 200);
</script>