<?php
$page = 'Book Marketing Services and Strategies | Publish With Pros';
$pageDesc = "Publish With Pros offers expert book marketing services and strategies to elevate your book’s visibility and drive sales. Trust us for top-notch promotion and growth.";
$pageTag = "";
include 'includes/header.php';
?>
<section class="section s1 home-banner nitro-lazy">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-7 div-text">
                <h1 class="heading">Clear and Clever <span class="marketing-page">Marketing</span> for Authors.
                </h1>
                <p>Strategic, insights-driven, custom-tailored services.</p>
                <ul class="list-style for-mul">
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Boost sales and ego.</span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Earn global recognition.</span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Gain the trust of your readers.</span>
                    </li>
                </ul>
                <div class="banner-btns"> <a href="#request" class="talk-chat"> Get
                        Started </a> <a href="tel:+<?php echo $phone ?>" class="talk-phone phons-mobile call-func"><i
                            class="fa-solid fa-phone"></i><?php echo $phone ?></a> </div>
            </div>
            <div class="col-md-5 div-img"><img width="501" height="611" alt="Book Cover"
                    src="img/banner_img.webp" />
            </div>
        </div>
    </div>
</section>
<section class="section s2" id="request">
    <div class="container">
        <div class="form-area">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-right" data-aos-duration="2000">
                    <div class="div-img">
                        <img alt="Request A Free Proposal" width="436" height="463" src="img/rfp-man.webp" />
                    </div>
                </div>
                <div class="col-md-6" data-aos="fade-left" data-aos-duration="2000">
                    <div class="form-head text-center">
                        <h2>Let's Discuss Your Next <span>Bestseller</span>.</h2>
                    </div>
                    <div class="footer-rfp form-style">
                        <div class="form-body">
                        <?php include "includes/form.php" ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s3" data-aos="fade-up" data-aos-duration="2000">
    <div class="container">
        <div class="heading text-center">
            <h2>Book Marketing Services Designed For You.</h2>
        </div>
        <div class="market-book-slider">
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Social Media" width="674" height="571" src="img/social-media-slide2.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Target Audience and Campaign Planning</h3>
                        <p>We will identify the target audience and develop a marketing plan to connect with
                            them. </p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Social Media" width="674" height="571" src="img/social-media-slide1.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Author Platform and Social Media</h3>
                        <p>We help you build your author platform with a website, Amazon pages, email marketing,
                            and social media to help readers discover your book.</p>
                    </div>
                </div>
            </div>

            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Social Media" width="674" height="571" src="img/social-media-slide3.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Interviews and Event Appearances</h3>
                        <p>Gain results through podcast, TV, and radio interviews, and features in print and
                            online media. Secure speaking engagements and write articles.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- <section class="section s8">
            <div class="container">
                <div class="rfp-section rfp-flex v2">
                    <div class="footer-rfp form-style" data-aos="fade-right" data-aos-duration="2000">
                        <div class="form-head">
                            <h2 class="hide-mob">Want More Book Sales? 
                            </h2>
                            <h3>Get a Free Consultation</h3>
                        </div>
                        <div class="form-body" id="hero-form">
                            <form action="javascript:;" method="POST" name="btm-form">
                                <div class="form-group">
                                    <div class="group-item">
                                        <input type="text" name="quote[name]" class="input-field" placeholder="Enter Full Name" required />
                                    </div>
                                    <div class="group-item">
                                        <input type="email" name="quote[email]" class="input-field" placeholder="Enter Email Here " required />
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="group-item">
                                        <input type="tel" name="quote[phone]" class="input-field" placeholder="Enter Phone Number" required />
                                    </div>
                                    <div class="group-item select-icon">
                                        <select class="form-control" name="quote[service]" id="service" required>
                                            <option value="" disabled="disabled" selected="">Select Service</option>
                                            <option value="Book Marketing">Book Marketing</option>
                                            <option value="Book Editing">Book Editing</option>
                                            <option value="Book Writing">Book Writing</option>
                                            <option value="Book Publishing">Book Publishing</option>
                                            <option value="Book Printing">Book Printing</option>
<option value="Audiobook">Audiobook Service</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <textarea name="brief" class="input-field" cols="" rows="1" placeholder="Tell Us What You’re Looking For" spellcheck="false"></textarea>
                                </div>
                                <div class="form-submit">
                                    <input class="form-btn" type="submit">
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="div-img" data-aos="fade-left" data-aos-duration="2000">
                        <img alt="Publish, Market & Print" width="401" height="708" src="img/rfp-girl.webp" />
                    </div>
                </div>
            </div>
        </section> -->
<section class="section s5 nitro-lazy">
    <div class="container">
        <div class="row">
            <div class="col-md-4 div-img" data-aos="fade-right" data-aos-duration="2000">
                <img alt="img" width="437" height="536" src="img/expert-book2.webp" />
            </div>
            <div class="col-md-8 div-text" data-aos="fade-left" data-aos-duration="2000">
                <h2>Leaving No Stones Unturned to Build Your Book’s Success </h2>
                <p>Getting your book the reach it deserves is the only thing on our minds. Here’s just a taste
                    of the successes you can experience on your book’s marketing journey.</p>
                <ul class="list-style">
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Tailored marketing strategy to reach
                            your audience.</span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Optimizing your digital assets,
                            including websites, Amazon pages, and social media pages </span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Securing interviews on print, podcasts,
                            TV, and radio.</span></li>
                    <li> <i class="fa-solid fa-circle-check"></i> <span>Assisting in writing by-lined articles
                            for added visibility.</span></li>
                </ul>
                <div class="banner-btns innder"> <a href="request-free-proposal.php" class="talk-chat"> Get
                        Started </a> <a href="tel:+<?php echo $phone ?>" class="talk-phone call-func"><i
                            class="fa-solid fa-phone"></i>Call Now</a> </div>
            </div>
        </div>
    </div>
</section>
<section class="section s6" data-aos="fade-down" data-aos-duration="2000">
    <div class="container merketing-com">
        <div class="heading text-center">
            <h2>How Our Book Marketing Process Works?</h2>
        </div>
        <div class="row ttff">
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-1.webp" alt="Number one">
                    <h4 class="mt-2">Initial Consultation</h4>
                    <p>Your journey starts with a call with your dedicated publishing consultant to understand
                        your goals, genre, and target audience for tailored strategies.</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-2.webp" alt="Number two">
                    <h4 class="mt-2">Author Involvement</h4>
                    <p>Our journey is collaborative. We value your insights, champion creativity, and encourage
                        your active participation to resonate with readers.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-3.webp" alt="Number three">
                    <h4 class="mt-2">Material Creation </h4>
                    <p>Our creative team crafts marketing materials like book descriptions, press releases, and
                        author bios to excite readers and media members.</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-4.webp" alt="Number four">
                    <h4 class="mt-2">Distribution and Promotion</h4>
                    <p>We distribute marketing materials to selected media contacts, promoting your book to
                        engaged readers and generating the needed buzz for success.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s7" data-aos="fade-in" data-aos-duration="2000">
    <div class="container">
        <div class="heading text-center width-70 m-auto">
            <h2>Q/A Session </h2>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="accordion">
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>01</p>
                            </span>
                            <h4> What types of books do you promote?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We promote a wide range of genres, including fiction, non-fiction, memoirs,
                                self-help, and more. Our services are tailored to fit the unique needs of each
                                book.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>02</p>
                            </span>
                            <h4> How do you identify the target audience for my book?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We conduct thorough market research and analyze your book’s genre, themes, and
                                comparable titles to identify and reach your target audience effectively.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>03</p>
                            </span>
                            <h4>What kind of marketing materials will you create for my book?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Our team will create engaging book descriptions, press releases, author
                                biographies, social media content, and other promotional materials tailored to
                                your book.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>04</p>
                            </span>
                            <h4>Will I have a say in the marketing strategy?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Absolutely! Our approach is collaborative. We value your input and ensure you are
                                actively involved in the development and execution of the marketing strategy.
                            </p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>05</p>
                            </span>
                            <h4>What is the duration of a typical book promotion campaign?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Campaign durations can vary, but a standard promotion typically lasts 3-6 months.
                                We tailor each campaign to meet the specific needs and goals of your book.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 faq-rowr">
                <div class="accordion">
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>06</p>
                            </span>
                            <h4>How do you handle book reviews and media coverage?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We reach out to reputable book reviewers, bloggers, and media outlets to secure
                                reviews, interviews, and features that increase your book’s visibility.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>07</p>
                            </span>
                            <h4> What social media platforms do you use for promotion?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We utilize major social media platforms like Facebook, Twitter, Instagram, and
                                LinkedIn to reach your target audience and engage with potential readers.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>08</p>
                            </span>
                            <h4>How do you measure the success of the promotional campaign?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We track various metrics, such as social media engagement, website traffic, book
                                sales, media coverage, and reviews, to evaluate the campaign’s effectiveness.
                            </p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>09</p>
                            </span>
                            <h4>Do you offer any post-launch promotional support?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we offer ongoing support post-launch to sustain your book’s momentum and
                                continue building your author brand through strategic promotions.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>10</p>
                            </span>
                            <h4>How do you handle book launches and events?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We coordinate book launch events, both virtual and in-person, secure speaking
                                engagements, and plan book signings to maximize visibility and audience
                                engagement.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php include "includes/footer.php" ?>