<?php
$page = 'Custom Book Printing Services | Publish With Pros';
$pageDesc = "Introducing Publish With Pros—your go-to for top-notch custom book printing services. We deliver the best in quality and precision, ensuring your manuscript looks exceptional.";
$pageTag = "";
include 'includes/header.php';
?>
<section class="section s1 home-banner nitro-lazy">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-7 div-text">
                <h1 class="heading">Print Your Books with <span class="printing-page">O</span>utstanding <span
                        class="printing-page">Q</span>uality</h1>
                <p>Get top-quality, custom printed books in hardcover and softcover formats. Whether you want to
                    print on demand or a thousand copies, our book printing services offer a seamless online
                    experience. </p>
                <div class="banner-btns"> <a href="javascript:;" class="talk-chat showPopup"> Get
                        Started </a> <a href="tel:<?php echo $phone ?>" class="talk-phone phons-mobile call-func"><i
                            class="fa-solid fa-phone"></i><?php echo $phone ?></a> </div>
            </div>
            <div class="col-md-5 div-img"><img width="501" height="611" alt="Book Cover"
                    src="img/banner_img.webp" />
            </div>
        </div>
    </div>
</section>
<section class="section s2" id="request">
    <div class="container">
        <div class="form-area">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-right" data-aos-duration="2000">
                    <div class="div-img">
                        <img alt="Request A Free Proposal" width="436" height="463" src="img/rfp-man.webp" />
                    </div>
                </div>
                <div class="col-md-6" data-aos="fade-left" data-aos-duration="2000">
                    <div class="form-head text-center">
                        <h2>Request A <span>Free Proposal</span>.</h2>
                    </div>
                    <div class="footer-rfp form-style">
                        <div class="form-body">
                            <?php include "includes/form.php" ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s3 special-secc" data-aos="fade-in" data-aos-duration="2000">
    <div class="container printing-com">
        <div class="heading text-center">
            <h2>Why Print Your Book with Publish With Pros?</h2>
        </div>
        <div class="row ttff">
            <div class="col-md-3">
                <div class="com">
                    <img src="img/print-icon-1.webp" alt="img">
                    <h4 class="mt-2">Fastest Turnaround Times</h4>
                    <p>Get your books printed in a flash—just 3-5 days, all done in our top-notch facility. Our
                        streamlined process ensures you meet your deadlines without compromising on quality.</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/print-icon-2.webp" alt="img">
                    <h4 class="mt-2">Premium quality</h4>
                    <p>Discover the excellence in every page with our books, printed on high-quality paper using
                        the latest technology for vibrant colors and sharp details.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/print-icon-3.webp" alt="img">
                    <h4 class="mt-2">Affordable pricing </h4>
                    <p>Discover unbeatable value for retail-ready books, available in every trim size. Whether
                        you need a small batch or a large volume, our pricing options are designed to fit any
                        budget. Get the perfect blend of quality and affordability with us!</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/print-icon-4.webp" alt="img">
                    <h4 class="mt-2">Printed In The USA</h4>
                    <p>Experience exceptional printing with our US-based facilities, where cutting-edge
                        technology meets swift delivery. Quality and speed are our promises, ensuring you
                        receive standout prints in no time.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s4 nitro-lazy" data-aos="fade-in" data-aos-duration="2000">
    <div class="container">
        <div class="heading text-center">
            <h2>Book Binding Services to Enhance Your Publications</h2>
        </div>
        <div class="market-book-slider">
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" width="674" height="571" src="img/printing-1.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Hardcover</h3>
                        <p>We provide durable hardcover binding for a polished appearance with strong, rigid
                            covers, ideal for longevity and premium presentation.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" width="674" height="571" src="img/printing-2.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Saddle Stitch</h3>
                        <p>Our saddle stitch binding offers an economical option using staples along the spine,
                            perfect for booklets, brochures, and shorter publications.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" width="674" height="571" src="img/printing-3.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Perfect Bound</h3>
                        <p>We offer sleek, perfect-bound books with a glued spine, providing a clean look
                            suitable for thicker publications and soft-cover books.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" width="674" height="571" src="img/printing-4.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Spiral</h3>
                        <p>Our spiral binding services provide flexible and easy-to-use books that lay flat,
                            ideal for manuals, workbooks, and cookbooks.</p>
                    </div>
                </div>
            </div>
            <div class="slide-item">
                <div class="slide-flex">
                    <div class="slide-img">
                        <img alt="Color Printing" width="674" height="571" src="img/printing-5.webp" />
                    </div>
                    <div class="slide-details">
                        <h3>Wire-O</h3>
                        <p>We offer Wire-O binding for a robust and polished finish, allowing pages to turn
                            easily and lay flat, perfect for presentations and planners.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- <section class="section s8">
            <div class="container">
                <div class="rfp-section rfp-flex v2">
                    <div class="footer-rfp form-style">
                        <div class="form-head" data-aos="fade-right" data-aos-duration="2000">
                            <h2 class="hide-mob">Get The Affordable Wholesale And Retail Book Printing Rates
                            </h2>
                            <h3>Free Consultation</h3>
                        </div>
                        <div class="form-body" id="hero-form" data-aos="fade-left" data-aos-duration="2000">
                            <form action="/leads/" method="POST" name="btm-form">
                                <div class="form-group">
                                    <div class="group-item">
                                        <input type="text" name="name" class="input-field" placeholder="Enter Full Name"
                                            required />
                                    </div>
                                    <div class="group-item">
                                        <input type="email" name="quote[email]" class="input-field"
                                            placeholder="Enter Email Here " required />
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="group-item">
                                        <input type="tel" name="quote[phone]" class="input-field"
                                            placeholder="Enter Phone Number" required />
                                    </div>
                                    <div class="group-item select-icon">
                                        <select class="form-control" name="quote[service]" id="service" required>
                                            <option value="" disabled="disabled" selected="">Select Service</option>
                                            <option value="Book Marketing">Book Marketing</option>
                                            <option value="Book Editing">Book Editing</option>
                                            <option value="Book Writing">Book Writing</option>
                                            <option value="Book Publishing">Book Publishing</option>
                                            <option value="Book Printing">Book Printing</option>
<option value="Audiobook">Audiobook Service</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <textarea name="brief" class="input-field" cols="" rows="1"
                                        placeholder="Tell Us What You’re Looking For" spellcheck="false"></textarea>
                                </div>
                                <div class="form-submit">
                                    <input class="form-btn" type="submit">
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="div-img">
                        <img alt="Publish, Market & Print" width="401" height="708" src="img/rfp-girl.webp" />
                    </div>
                </div>
            </div>
        </section> -->
<section class="section s6" data-aos="fade-down" data-aos-duration="2000">
    <div class="container printing-com">
        <div class="heading text-center">
            <h2>Our Seamless Book Printing Process</h2>
        </div>
        <div class="row ttff">
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-1.webp" alt="Number one">
                    <h4 class="mt-2">Consultation</h4>
                    <p>We start by understanding your vision, discussing project specifics, and offering expert
                        advice on design, format, and binding options.</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-2.webp" alt="Number two">
                    <h4 class="mt-2">Design and Proofing</h4>
                    <p>Our design team collaborates with you to create a visually appealing layout. We then
                        provide digital proofs for review and approval.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-3.webp" alt="Number three">
                    <h4 class="mt-2">Printing and Binding</h4>
                    <p>Utilizing state-of-the-art printing technology, we produce high-quality pages and bind
                        them using your selected method to ensure a professional finish.</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="com">
                    <img src="img/num-4.webp" alt="Number four">
                    <h4 class="mt-2">Quality Check and Delivery</h4>
                    <p>Each book undergoes a meticulous quality check before packaging. We then deliver your
                        finished products promptly to your specified location.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section s7" data-aos="fade-in" data-aos-duration="2000">
    <div class="container">
        <div class="heading text-center width-70 m-auto">
            <h2>Q/A Session </h2>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="accordion">
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>01</p>
                            </span>
                            <h4> What types of binding options do you offer? </h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We provide a variety of binding options, including hardcover, saddle stitch,
                                perfect bound, spiral, and Wire-O to suit your book’s needs.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>02</p>
                            </span>
                            <h4> Can I see proof before my book is printed?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we offer digital proofs for your review and approval to ensure that the
                                final product meets your expectations.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>03</p>
                            </span>
                            <h4>What file formats do you accept for printing?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We accept various file formats, with PDF being the preferred format to maintain
                                layout and font integrity.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>04</p>
                            </span>
                            <h4>What is your turnaround time for printing?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Turnaround time varies based on the project scope, typically ranging from a few
                                days to a couple of weeks. We’ll provide an estimated timeline during
                                consultation.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>05</p>
                            </span>
                            <h4>Do you offer design services?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, our experienced design team can assist with creating an appealing,
                                professional layout for your book, including cover design and interior
                                formatting.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 faq-rowr">
                <div class="accordion">
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>06</p>
                            </span>
                            <h4>Is there a minimum order quantity?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>The minimum order quantity depends on the service chosen. We can accommodate both
                                small runs and large-scale printing projects.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>07</p>
                            </span>
                            <h4>Can you help with ISBN and barcode generation?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we can assist with obtaining an ISBN and generating a barcode for your book,
                                which is essential for retail distribution.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>08</p>
                            </span>
                            <h4> What paper options are available? </h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>We offer a range of paper types and weights, from standard to premium, allowing
                                customization based on your book’s specific needs.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>09</p>
                            </span>
                            <h4>Do you provide eco-friendly printing options?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Yes, we offer eco-friendly printing options using recycled paper and soy-based
                                inks to minimize environmental impact.</p>
                        </div>
                    </div>
                    <div class="accordion__item">
                        <div class="accordion__item__header"> <span class="icon-count">
                                <p>10</p>
                            </span>
                            <h4>Can you handle bulk orders for events or organizations?</h4>
                        </div>
                        <div class="accordion__item__content" style="display:none;">
                            <p>Absolutely, we can manage bulk orders efficiently, ensuring timely delivery for
                                events, corporate needs, or large-scale distribution.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php include "includes/footer.php" ?>