<?php
$page = 'Privacy Policy | Publish With Pros';
$pageDesc = "Review our privacy policy to understand how we safeguard your personal information and data. Learn about our practices and your rights.";
$pageTag = "";
include 'includes/header.php';
?>
        <section class="section " style="background-image:none !important;">
            <div class="container">
                <div class="heading text-center">
                    <h1>Privacy Policy</h1>
                </div>
                <div class="para">
                    <p>At Publish With Pros, safeguarding your privacy and maintaining confidentiality are top
                        priorities. We are committed to outlining clear practices that ensure your personal and
                        proprietary information is protected. Below, you will find the details of our privacy policy:
                    </p>
                </div>
                <div class="para">
                    <h2>Information We Collect</h2>
                    <p>We gather information from you when you register on our site, place an order, subscribe to our
                        newsletter, or fill out any forms.</p>
                    <p>When you order or register on our site, you may be asked to provide details such as your name,
                        email address, mailing address, phone number, and credit card information, depending on the
                        context.</p>
                </div>
                <div class="para">
                    <h2>Purpose of Information Use</h2>
                    <p>The information we collect from you is used for the following purposes:</p>
                    <ul>
                        <li><i class="fa-solid fa-circle-check"></i><b>To personalize your experience:</b> Your
                            information allows us to better tailor our services to your specific needs.</li>
                        <li><i class="fa-solid fa-circle-check"></i> <b>To enhance our website:</b> We continuously work
                            to improve our website offerings based on the information and feedback we receive from you.
                        </li>
                        <li><i class="fa-solid fa-circle-check"></i> <b>To improve customer service:</b> Your
                            information helps us respond more effectively to your customer service requests and support
                            needs.</li>
                        <li><i class="fa-solid fa-circle-check"></i> <b>To process transactions:</b> Your information,
                            whether public or private, will not be sold, exchanged, transferred, or given to any other
                            company without your consent, except as necessary to fulfill the purchased product or
                            service you requested.</li>
                        <li><i class="fa-solid fa-circle-check"></i> <b>To send periodic emails:</b> The email address
                            you provide may be used to send you updates, respond to inquiries, and address other
                            requests or questions.</li>
                    </ul>
                </div>
                <div class="para">
                    <h2>Protection of Your Information</h2>
                    <p>We implement a range of security measures to protect your personal information whenever you place
                        an order, or enter, submit, or access your information.</p>
                    <p>We use a secure server. Any sensitive/credit information you provide is transmitted via Secure
                        Socket Layer (SSL) technology and then encrypted into our payment gateway provider's database.
                        This information is only accessible to individuals who have special access rights to these
                        systems and who are required to maintain the confidentiality of the information.</p>
                    <p>After a transaction is completed, your private information (such as credit card details, social
                        security numbers, and financial information) will not be stored on our servers.</p>
                </div>
                <div class="para">
                    <h2>Use of Cookies</h2>
                    <p>Yes, we use cookies. Cookies are small files that a website or its service provider transfers to
                        your computer's hard drive through your web browser (if you allow) that enable the site or
                        service provider to recognize your browser and capture and retain certain information.</p>
                    <p>We use cookies to monitor advertisements and to compile aggregate data regarding site traffic and
                        interactions so we can enhance site experiences and tools in the future. We may also partner
                        with third-party service providers to help us better understand our site visitors. These service
                        providers are not allowed to use the information collected on our behalf except to assist us in
                        conducting and improving our business.</p>
                </div>
                <div class="para">
                    <h2>Disclosure of Information to Third Parties</h2>
                    <p>We do not sell, trade, or otherwise transfer your personally identifiable information to outside
                        parties. This does not include trusted third parties who assist us in operating our website,
                        conducting our business, or providing services to you, as long as those parties agree to keep
                        this information confidential. We may also disclose your information if we believe it is
                        necessary to comply with the law, enforce our site policies, or protect the rights, property, or
                        safety of ourselves or others. However, non-personally identifiable visitor information may be
                        provided to other parties for marketing, advertising, or other uses.</p>
                </div>
                <div class="para">
                    <h2>Third-Party Links</h2>
                    <p>Occasionally, we may include or offer third-party products or services on our website at our
                        discretion. These third-party sites have separate and independent privacy policies. We,
                        therefore, hold no responsibility or liability for the content and activities of these linked
                        sites. Nonetheless, we strive to protect the integrity of our site and welcome any feedback
                        regarding these external sites.</p>
                </div>
                <div class="para">
                    <h2>Compliance with California Online Privacy Protection Act</h2>
                    <p>We value your privacy and have taken the necessary steps to comply with the California Online
                        Privacy Protection Act. Consequently, we will not distribute your personal information to
                        external parties without your consent.</p>
                </div>
                <div class="para">
                    <h2>Online Privacy Policy Scope</h2>
                    <p>This online privacy policy applies solely to information collected through our website and does
                        not extend to information gathered offline.</p>
                </div>
                <div class="para">
                    <h2>Terms and Conditions</h2>
                    <p>Please also review our Terms and Conditions section, which outlines the use, disclaimers, and
                        limitations of liability governing the use of our website.</p>
                </div>
                <div class="para">
                    <h2>Changes to Our Privacy Policy</h2>
                    <p>Publish With Pros reserves the right to revise or update our privacy policy at any time. Any
                        modifications to the policy will be posted on this page for your convenience. Your continued use
                        of our services after such changes will indicate your acceptance of the revised policy.</p>
                </div>
                <div class="para">
                    <h2>Contact Information</h2>
                    <p>If you have any questions or concerns regarding our privacy policy, please feel free to contact
                        us:</p>
                    <p><b>Email:</b> info@selfpublishersexperts.com</p>
                    <p class="call-func"><b>Phone:</b> <?php echo $phone ?> </p>
                    <p><b>Address:</b> <?php echo $address ?></p>

                    <p>Thank you for choosing Publish With Pros. We are committed to supporting your journey to
                        successful book publication and look forward to our collaboration!</p>
                </div>
            </div>
        </section>
        <?php include "includes/footer.php" ?>