<?php
$page = 'Terms and Conditions: Service Guidelines | Publish With Pros';
$pageDesc = "Read our terms and conditions to understand the rules and guidelines for using our services. Stay informed about our legal terms and agreements.";
$pageTag = "";
include 'includes/header.php';
?>
<section class="section " style="background-image:none !important;">
    <div class="container">
        <div class="heading text-center">
            <h1>Terms & Conditions</h1>
        </div>
        <div class="para">
            <h2>Policy Scope</h2>
            <p>These terms and conditions apply to all services provided through our website, including but not
                limited to:</p>
            <ul class="inline-list">
                <li><i class="fa-solid fa-circle-check"></i> Book Writing</li>
                <li><i class="fa-solid fa-circle-check"></i> Book Editing</li>
                <li><i class="fa-solid fa-circle-check"></i> Book Publishing</li>
                <li><i class="fa-solid fa-circle-check"></i> Book Marketing</li>
                <li><i class="fa-solid fa-circle-check"></i> Book Printing</li>
                <li><i class="fa-solid fa-circle-check"></i> Audiobook</li>
            </ul>
        </div>
        <div class="para">
            <h2>Revision Policy After Project Completion</h2>
            <p>Following the completion of your project, our revision policy is as follows:</p>
            <ul>
                <li><i class="fa-solid fa-circle-check"></i>Contact our customer support team within 07 days
                    from the date you receive the final project deliverables or the project completion date,
                    whichever is applicable.</li>
                <li><i class="fa-solid fa-circle-check"></i> Requests for revisions beyond this 07-day period
                    will require the placement of a new order.</li>
            </ul>
            <p><b>Note:</b> Revisions are confined to the parameters of the initial project brief. Should your
                revision requests exceed the agreed terms, additional charges may be necessary.</p>
        </div>
        <div class="para">
            <h2>Refund Process</h2>
            <p>To be eligible for a refund, the following criteria must be met:</p>
            <ul>
                <li><i class="fa-solid fa-circle-check"></i>Initiate contact with our customer support team
                    within 07 days of receiving the final project deliverables or upon reaching the project
                    completion date.</li>
                <li><i class="fa-solid fa-circle-check"></i>Provide a comprehensive explanation detailing your
                    dissatisfaction, even if our unlimited revisions policy has been utilized.</li>
                <li><i class="fa-solid fa-circle-check"></i>Confirm that none of the project deliverables have
                    been used in any form of promotional activity or displayed on any digital platforms.</li>
                <li><i class="fa-solid fa-circle-check"></i>Clearly state how the delivered project fails to
                    align with the pre-established specifications.</li>
            </ul>
        </div>
        <div class="para">
            <h2>Refund Eligibility</h2>
            <p>To initiate a refund, please:</p>
            <ul>
                <li><i class="fa-solid fa-circle-check"></i> Contact our customer support team either by calling
                    <a href="tel:<?php echo $phone ?>" class="call-func"><?php echo $phone ?></a> or emailing <a
                        href="mailto:info@selfpublishersexperts.com">info@selfpublishersexperts.com</a> within the
                    designated timeframe.
                </li>
                <li><i class="fa-solid fa-circle-check"></i>Provide a detailed account of your concerns and the
                    reasons behind your refund request.</li>
                <li><i class="fa-solid fa-circle-check"></i> Allow us a period of five business days to conduct
                    an internal review and propose potential alternatives.</li>
                <li><i class="fa-solid fa-circle-check"></i>If a mutual agreement on alternative solutions
                    cannot be reached, we will begin the refund process, with specifics managed by your
                    designated project manager.</li>
            </ul>
        </div>
        <div class="para">
            <h2>Partial Refunds</h2>
            <p>Under certain conditions, we may issue partial refunds, particularly in cases where a portion of
                a service, such as book marketing, has been utilized but not fully completed. We will calculate
                the refund amount for the unused portion of the service while invoicing for the services that
                have already been provided.</p>
        </div>
        <div class="para">
            <h2>Services Exempt from Refunds</h2>
            <p>Fees paid to third parties are not eligible for refunds. This includes but is not limited to,
                expenses related to pay-per-click (PPC) advertisements, influencer fees, and other third-party
                engagements. Additionally, due to the tangible nature of book printing, these services are
                non-refundable.
            </p>
            <p><b>Note:</b> Charges related to the initial setup and optimization of services are also
                non-refundable.
            </p>
        </div>
        <div class="para">
            <h2>Modification to Refund Policy</h2>
            <p>We reserve the right to modify or update our refund policy at any time. Any revisions will be
                published on this page for easy access. Continued use of our services following such
                modifications constitutes your acceptance of the new terms.
            </p>
        </div>
        <div class="para">
            <h2>Guarantee of Content Originality</h2>
            <p>We offer, upon request, premium Copyscape reports to verify the originality of the content,
                assessing text against information contained in webpages indexed by search engines. Please note
                that Copyscape does not review text embedded within images or other forms of non-text media. We
                guarantee that our content will be recognized as original according to Copyscape's standards,
                but extensive plagiarism detection is the client's responsibility.</p>
            <p>Should plagiarism be detected in the materials you provide, we will advise on the best course of
                action for edits. Note that significant modifications required to address extensive plagiarism
                may result in additional fees.</p>
        </div>
        <div class="para">
            <h2>Rights to Images</h2>
            <p>We do not claim ownership or rights over any images recommended for your projects. Clients will
                receive links to access and, if necessary, purchase rights to use these images from third-party
                vendors before their use.</p>
        </div>
        <div class="para">
            <h2>Publication of Images</h2>
            <p>We provide recommendations for image use tailored to your specific project requirements. Clients
                are responsible for adhering to the copyright guidelines set by the image's rightful owner,
                which may include purchasing the image or securing proper attribution.</p>
        </div>
        <div class="para">
            <h2>Submission of Project-Related Documents</h2>
            <p>We prefer receiving all project-related documents electronically, either through email or via the
                client dashboard, to enhance efficiency and response time. Should physical document submission
                be necessary, it may incur additional Document Processing Charges depending on the complexity
                and urgency of the documents.</p>
        </div>
        <div class="para">
            <h2>Limitation of Liability</h2>
            <p>Under no circumstances shall Publish With Pros or its associated entities be held liable for
                any damages that arise from the use of our services or website. This includes but is not limited
                to, damages allegedly sourced from viruses purportedly obtained from the website.</p>
        </div>
        <div class="para">
            <h2>Warranty Disclaimer</h2>
            <p>Publish With Pros provides all services and materials "as is," without any warranty, whether
                expressed or implied. We expressly disclaim any liability for errors or omissions in the
                materials provided, including warranties of merchantability, fitness for a particular purpose,
                or non-infringement.</p>
        </div>
        <div class="para">
            <h2>Amendments to Terms & Conditions</h2>
            <p>We reserve the right to amend these terms and conditions at any time. All updates will be posted
                on this page, ensuring they are readily accessible. Continued use of our services after these
                updates will signify your agreement to the revised terms.</p>
        </div>
        <div class="para">
            <h2>Contact Information</h2>
            <p>For any questions or concerns about these terms, please reach out to us:</p>
            <p><b>Email:</b> info@selfpublishersexperts.com</p>
            <p><b>Phone:</b> <?php echo $phone ?> </p>
            <p><b>Address:</b> <?php echo $address ?></p>
            <p>Thank you for choosing Publish With Pros. We are committed to supporting your journey to
                successful book publication and look forward to our collaboration!</p>
        </div>
    </div>
</section>
<?php include "includes/footer.php" ?>